import {Subscription} from "rxjs";
import {
  isFunction,
  isReference,
  isTruthy,
} from "../tools/is/is.tool";

export class SubscriptionUtil {

  static isUnsubscribable(subscription: Subscription): boolean {
    return isReference(subscription) && isFunction(subscription.unsubscribe) && !subscription.closed;
  }

  static unsubscribe(subscription: Subscription): boolean {
    if (this.isUnsubscribable(subscription)) {
      subscription.unsubscribe();
      return isTruthy(subscription.closed);
    }
    return false;
  }

}
