import {ChangeCase} from "../lib-wrapped/change-case.model";
import {KeyValue} from "../models/query-parameters/key-value.model";

export class StringUtil {
  static readonly stringEmpty: string = "";

  static format(str: string, ...val: string[]): string {
    for (let i = 0; i < val.length; i++) {
      str = str.replace(`{${i}}`, val[i]);
    }
    return str;
  }

  static formatKeyValue(str: string, ...val: KeyValue[]): string {
    val.forEach(v => {
      str = str.replace(`{${v.key}}`, v.value);
    });
    return str;
  }

  static convertSpinalCaseToPascalCase(origin: string): string {
    origin = origin.replace("-", " ");
    return ChangeCase.pascalCase(origin);
  }

  static convertSpinalCaseToCamelCase(origin: string): string {
    origin = origin.replace("-", " ");
    return ChangeCase.camelCase(origin);
  }

  static convertToCamelCase(origin: string): string {
    return ChangeCase.camelCase(origin);
  }

  static convertToSpinalCase(origin: string): string {
    origin = origin.replace(" ", "-");
    return ChangeCase.paramCase(origin);
  }

  static convertToSnakeCase(origin: string): string {
    origin = origin.replace(" ", "_");
    return ChangeCase.snakeCase(origin);
  }

  static convertToPascalCase(origin: string): string {
    return ChangeCase.pascalCase(origin);
  }

  static replaceAll(str: string, oldChar: string, newChar: string): string {
    const strSplitter = str.split(oldChar);
    return strSplitter.join(newChar);
  }
}
