import {KeyValue} from "../models";
import {StringUtil} from "./string.util";

describe("StringUtil", () => {
  describe("format", () => {
    it("should insert 2 values in string", () => {
      const originalString = "My string with {0} injected value and {1} value";
      const val1 = "val1";
      const val2 = "val2";
      const result = StringUtil.format(originalString, val1, val2);
      expect(result).toBe("My string with val1 injected value and val2 value");
    });

    it("should insert 1 string in string that have 2 unresolved value", () => {
      const originalString = "My string with {0} injected value and {1} value";
      const val1 = "val1";
      const result = StringUtil.format(originalString, val1);
      expect(result).toBe("My string with val1 injected value and {1} value");
    });
  });

  describe("formatKeyValue", () => {
    it("should insert 2 values in string by key", () => {
      const originalString = "My string with {key1} injected value and {key2} value";
      const keyValue1 = new KeyValue("key1", "val2");
      const keyValue2 = new KeyValue("key2", "val1");
      const result = StringUtil.formatKeyValue(originalString, keyValue2, keyValue1);
      expect(result).toBe("My string with val2 injected value and val1 value");
    });
  });

  describe("convertSpinalCaseToPascalCase", () => {
    it("should convert spinalCase to PascalCase", () => {
      expect(StringUtil.convertSpinalCaseToPascalCase("my-string")).toBe("MyString");
    });
  });

  describe("convertSpinalCaseToCamelCase", () => {
    it("should convert spinalCase to camelCase", () => {
      expect(StringUtil.convertSpinalCaseToCamelCase("my-string")).toBe("myString");
    });
  });

  describe("convertToPascalCase", () => {
    it("should convert string to PascalCase", () => {
      expect(StringUtil.convertToPascalCase("my string")).toBe("MyString");
    });
  });
});
