import {RegisteredDefaultAction} from "../../decorators/store.decorator";
import {BaseStoreNameSpace} from "../../models/stores/base-store-namespace.model";
import {isTruthyObject} from "../../tools/is/is.tool";
import defineProperty = Reflect.defineProperty;

export const SOLIDIFY_META_KEY = "SOLIDIFY_META";

export interface SolidifyStateClass<T extends BaseStoreNameSpace> {
  [SOLIDIFY_META_KEY]?: SolidifyMetaDataModel<T>;

  new(...args: any[]): any;
}

export interface SolidifyMetaDataModel<T extends BaseStoreNameSpace> {
  defaultActions?: RegisteredDefaultAction<T>[] | undefined;
  excludedRegisteredDefaultActionFns?: string[] | undefined;
}

export class SolidifyMetadataUtil {
  /**
   * Ensures metadata is attached to the class and returns it.
   */
  static ensureStoreSolidifyMetadata<T extends BaseStoreNameSpace>(target: SolidifyStateClass<T>): SolidifyMetaDataModel<T> {
    if (!target.hasOwnProperty(SOLIDIFY_META_KEY) || !isTruthyObject(target[SOLIDIFY_META_KEY])) {
      defineProperty(target, SOLIDIFY_META_KEY, {value: {}, enumerable: true, writable: true});
    }
    return target[SOLIDIFY_META_KEY];
  }
}
