import {ResourceNameSpace} from "../../stores/resource";
import {
  SOLIDIFY_META_KEY,
  SolidifyMetaDataModel,
  SolidifyMetadataUtil,
  SolidifyStateClass,
} from "./solidify-metadata.util";

describe("SolidifyMetadataUtil", () => {
  describe("ensureStoreSolidifyMetadata", () => {
    it("should return metadata when no meta defined", () => {
      const target = {};
      const result = SolidifyMetadataUtil.ensureStoreSolidifyMetadata<ResourceNameSpace>(target as SolidifyStateClass<ResourceNameSpace>);
      expect(result).not.toBeNull();
      expect(result).not.toBeUndefined();
      expect(target[SOLIDIFY_META_KEY]).toBe(result);
      expect(result.excludedRegisteredDefaultActionFns).toBeUndefined();
      expect(result.defaultActions).toBeUndefined();
    });

    it("should return metadata when meta defined", () => {
      const target = {
        [SOLIDIFY_META_KEY]: {
          defaultActions: [],
          excludedRegisteredDefaultActionFns: [],
        } as SolidifyMetaDataModel<ResourceNameSpace>,
      };
      const result = SolidifyMetadataUtil.ensureStoreSolidifyMetadata<ResourceNameSpace>(target as SolidifyStateClass<ResourceNameSpace>);
      expect(result).not.toBeNull();
      expect(result).not.toBeUndefined();
      expect(target[SOLIDIFY_META_KEY]).toBe(result);
      expect(result.excludedRegisteredDefaultActionFns.length).toBe(0);
      expect(result.defaultActions.length).toBe(0);
    });
  });

});
