import {Type} from "@angular/core";
import {Store} from "@ngxs/store";
import {Observable} from "rxjs";
import {
  distinctUntilChanged,
  filter,
  map,
  take,
} from "rxjs/operators";
import {
  BaseRelationResourceType,
  BaseResourceType,
  BaseStateModel,
  QueryParameters,
} from "../../models";
import {
  AssociationState,
  AssociationStateModel,
} from "../../stores/association";
import {
  AssociationNoSqlReadOnlyState,
  AssociationNoSqlReadOnlyStateModel,
} from "../../stores/association-no-sql-read-only";
import {
  AssociationRemoteState,
  AssociationRemoteStateModel,
} from "../../stores/association-remote";
import {BasicState} from "../../stores/base";
import {
  CompositionState,
  CompositionStateModel,
} from "../../stores/composition";
import {
  Relation2TiersState,
  Relation2TiersStateModel,
} from "../../stores/relation-2-tiers";
import {
  Relation3TiersState,
  Relation3TiersStateModel,
} from "../../stores/relation-3-tiers";
import {
  ResourceState,
  ResourceStateModel,
} from "../../stores/resource";
import {
  ResourceNoSqlReadOnlyState,
  ResourceNoSqlReadOnlyStateModel,
} from "../../stores/resource-no-sql-read-only";
import {
  ResourceReadOnlyState,
  ResourceReadOnlyStateModel,
} from "../../stores/resource-read-only";
import {
  isFunction,
  isNullOrUndefined,
} from "../../tools";

// @dynamic
export class MemoizedUtil {
  static select<TStateModel extends BaseStateModel, T>(store: Store,
                                                       ctor: Type<BasicState<TStateModel>>,
                                                       selector: (state: TStateModel) => T,
                                                       distinct?: boolean | ((x: T, y: T) => boolean)): Observable<T> {
    const memoizedSelector = store.select(ctor).pipe(
      filter(state => !isNullOrUndefined(state)),
      map(value => selector(value)),
    );
    return distinct ? memoizedSelector.pipe(isFunction(distinct) ? distinctUntilChanged(distinct) : distinctUntilChanged()) : memoizedSelector;
  }

  static selectSnapshot<TStateModel extends BaseStateModel, T>(store: Store,
                                                               ctor: Type<BasicState<TStateModel>>,
                                                               selector: (state: TStateModel) => T): T {
    return selector(store.selectSnapshot(ctor));
  }

  static selectOnce<TStateModel extends BaseStateModel, T>(store: Store,
                                                           ctor: Type<BasicState<TStateModel>>,
                                                           selector: (state: TStateModel) => T): Observable<T> {
    return store.select(ctor).pipe(
      filter(state => !isNullOrUndefined(state)),
      take(1),
      map(value => selector(value)),
    );
  }

  static isLoading<TStateModel extends BaseStateModel>(store: Store, ctor: Type<BasicState<TStateModel>>): Observable<boolean> {
    return this.select(store, ctor, state => state.isLoadingCounter > 0, true);
  }

  static isLoadingSnapshot<TStateModel extends BaseStateModel>(store: Store, ctor: Type<BasicState<TStateModel>>): boolean {
    return this.selectSnapshot(store, ctor, state => state.isLoadingCounter > 0);
  }

  static selected<TStateModel extends AssociationStateModel<TResource>
    | AssociationNoSqlReadOnlyStateModel<TResource>
    | AssociationRemoteStateModel<TResource>
    | Relation2TiersStateModel<TResource>
    | Relation3TiersStateModel<TResource>
    , TResource extends BaseResourceType, TRelation extends BaseRelationResourceType>(
    store: Store,
    ctor: Type<AssociationState<TStateModel, TResource>>
      | Type<AssociationNoSqlReadOnlyState<TStateModel, TResource>>
      | Type<AssociationRemoteState<TStateModel, TResource>>
      | Type<Relation2TiersState<TStateModel, TResource, TRelation>>
      | Type<Relation3TiersState<TStateModel, TResource, TRelation>>,
  ): Observable<TResource[]> {
    return MemoizedUtil.select(store, ctor, state => state.selected, true);
  }

  static selectedSnapshot<TStateModel extends AssociationStateModel<TResource>
    | AssociationNoSqlReadOnlyStateModel<TResource>
    | AssociationRemoteStateModel<TResource>
    | Relation2TiersStateModel<TResource>
    | Relation3TiersStateModel<TResource>
    , TResource extends BaseResourceType, TRelation extends BaseRelationResourceType>(
    store: Store,
    ctor: Type<AssociationState<TStateModel, TResource>>
      | Type<AssociationNoSqlReadOnlyState<TStateModel, TResource>>
      | Type<AssociationRemoteState<TStateModel, TResource>>
      | Type<Relation2TiersState<TStateModel, TResource, TRelation>>
      | Type<Relation3TiersState<TStateModel, TResource, TRelation>>,
  ): TResource[] {
    return MemoizedUtil.selectSnapshot(store, ctor, state => state.selected);
  }

  static list<TStateModel extends CompositionStateModel<TResource>
    | ResourceStateModel<TResource>
    | ResourceNoSqlReadOnlyStateModel<TResource>
    | ResourceReadOnlyStateModel<TResource>
    , TResource extends BaseResourceType, TRelation extends BaseRelationResourceType>(
    store: Store,
    ctor: Type<CompositionState<TStateModel, TResource>>
      | Type<ResourceState<TStateModel, TResource>>
      | Type<ResourceNoSqlReadOnlyState<TStateModel, TResource>>
      | Type<ResourceReadOnlyState<TStateModel, TResource>>,
  ): Observable<TResource[]> {
    return MemoizedUtil.select(store, ctor, state => state.list, true);
  }

  static listSnapshot<TStateModel extends CompositionStateModel<TResource>
    | ResourceStateModel<TResource>
    | ResourceNoSqlReadOnlyStateModel<TResource>
    | ResourceReadOnlyStateModel<TResource>
    , TResource extends BaseResourceType, TRelation extends BaseRelationResourceType>(
    store: Store,
    ctor: Type<CompositionState<TStateModel, TResource>>
      | Type<ResourceState<TStateModel, TResource>>
      | Type<ResourceNoSqlReadOnlyState<TStateModel, TResource>>
      | Type<ResourceReadOnlyState<TStateModel, TResource>>,
  ): TResource[] {
    return MemoizedUtil.selectSnapshot(store, ctor, state => state.list);
  }

  static total<TStateModel extends AssociationStateModel<TResource>
    | AssociationNoSqlReadOnlyStateModel<TResource>
    | AssociationRemoteStateModel<TResource>
    | CompositionStateModel<TResource>
    | Relation2TiersStateModel<TResource>
    | Relation3TiersStateModel<TResource>
    | ResourceStateModel<TResource>
    | ResourceNoSqlReadOnlyStateModel<TResource>
    | ResourceReadOnlyStateModel<TResource>
    , TResource extends BaseResourceType, TRelation extends BaseRelationResourceType>(
    store: Store,
    ctor: Type<AssociationState<TStateModel, TResource>>
      | Type<AssociationNoSqlReadOnlyState<TStateModel, TResource>>
      | Type<AssociationRemoteState<TStateModel, TResource>>
      | Type<CompositionState<TStateModel, TResource>>
      | Type<Relation2TiersState<TStateModel, TResource, TRelation>>
      | Type<Relation3TiersState<TStateModel, TResource, TRelation>>
      | Type<ResourceState<TStateModel, TResource>>
      | Type<ResourceNoSqlReadOnlyState<TStateModel, TResource>>
      | Type<ResourceReadOnlyState<TStateModel, TResource>>,
  ): Observable<number> {
    return MemoizedUtil.select(store, ctor, state => state.total, true);
  }

  static totalSnapshot<TStateModel extends AssociationStateModel<TResource>
    | AssociationNoSqlReadOnlyStateModel<TResource>
    | AssociationRemoteStateModel<TResource>
    | CompositionStateModel<TResource>
    | Relation2TiersStateModel<TResource>
    | Relation3TiersStateModel<TResource>
    | ResourceStateModel<TResource>
    | ResourceNoSqlReadOnlyStateModel<TResource>
    | ResourceReadOnlyStateModel<TResource>
    , TResource extends BaseResourceType, TRelation extends BaseRelationResourceType>(
    store: Store,
    ctor: Type<AssociationState<TStateModel, TResource>>
      | Type<AssociationNoSqlReadOnlyState<TStateModel, TResource>>
      | Type<AssociationRemoteState<TStateModel, TResource>>
      | Type<CompositionState<TStateModel, TResource>>
      | Type<Relation2TiersState<TStateModel, TResource, TRelation>>
      | Type<Relation3TiersState<TStateModel, TResource, TRelation>>
      | Type<ResourceState<TStateModel, TResource>>
      | Type<ResourceNoSqlReadOnlyState<TStateModel, TResource>>
      | Type<ResourceReadOnlyState<TStateModel, TResource>>,
  ): number {
    return MemoizedUtil.selectSnapshot(store, ctor, state => state.total);
  }

  static current<TStateModel extends AssociationStateModel<TResource>
    | AssociationNoSqlReadOnlyStateModel<TResource>
    | AssociationRemoteStateModel<TResource>
    | Relation2TiersStateModel<TResource>
    | Relation3TiersStateModel<TResource>
    | ResourceStateModel<TResource>
    | ResourceNoSqlReadOnlyStateModel<TResource>
    | ResourceReadOnlyStateModel<TResource>
    , TResource extends BaseResourceType, TRelation extends BaseRelationResourceType>(
    store: Store,
    ctor: Type<AssociationState<TStateModel, TResource>>
      | Type<AssociationNoSqlReadOnlyState<TStateModel, TResource>>
      | Type<AssociationRemoteState<TStateModel, TResource>>
      | Type<Relation2TiersState<TStateModel, TResource, TRelation>>
      | Type<Relation3TiersState<TStateModel, TResource, TRelation>>
      | Type<ResourceState<TStateModel, TResource>>
      | Type<ResourceNoSqlReadOnlyState<TStateModel, TResource>>
      | Type<ResourceReadOnlyState<TStateModel, TResource>>,
  ): Observable<TResource> {
    return MemoizedUtil.select(store, ctor, state => state.current, true);
  }

  static currentSnapshot<TStateModel extends AssociationStateModel<TResource>
    | AssociationNoSqlReadOnlyStateModel<TResource>
    | AssociationRemoteStateModel<TResource>
    | Relation2TiersStateModel<TResource>
    | Relation3TiersStateModel<TResource>
    | ResourceStateModel<TResource>
    | ResourceNoSqlReadOnlyStateModel<TResource>
    | ResourceReadOnlyStateModel<TResource>
    , TResource extends BaseResourceType, TRelation extends BaseRelationResourceType>(
    store: Store,
    ctor: Type<AssociationState<TStateModel, TResource>>
      | Type<AssociationNoSqlReadOnlyState<TStateModel, TResource>>
      | Type<AssociationRemoteState<TStateModel, TResource>>
      | Type<Relation2TiersState<TStateModel, TResource, TRelation>>
      | Type<Relation3TiersState<TStateModel, TResource, TRelation>>
      | Type<ResourceState<TStateModel, TResource>>
      | Type<ResourceNoSqlReadOnlyState<TStateModel, TResource>>
      | Type<ResourceReadOnlyState<TStateModel, TResource>>,
  ): TResource | undefined {
    return MemoizedUtil.selectSnapshot(store, ctor, state => state.current);
  }

  static queryParameters<TStateModel extends AssociationStateModel<TResource>
    | AssociationNoSqlReadOnlyStateModel<TResource>
    | AssociationRemoteStateModel<TResource>
    | CompositionStateModel<TResource>
    | Relation2TiersStateModel<TResource>
    | Relation3TiersStateModel<TResource>
    | ResourceStateModel<TResource>
    | ResourceNoSqlReadOnlyStateModel<TResource>
    | ResourceReadOnlyStateModel<TResource>
    , TResource extends BaseResourceType, TRelation extends BaseRelationResourceType>(
    store: Store,
    ctor: Type<AssociationState<TStateModel, TResource>>
      | Type<AssociationNoSqlReadOnlyState<TStateModel, TResource>>
      | Type<AssociationRemoteState<TStateModel, TResource>>
      | Type<CompositionState<TStateModel, TResource>>
      | Type<Relation2TiersState<TStateModel, TResource, TRelation>>
      | Type<Relation3TiersState<TStateModel, TResource, TRelation>>
      | Type<ResourceState<TStateModel, TResource>>
      | Type<ResourceNoSqlReadOnlyState<TStateModel, TResource>>
      | Type<ResourceReadOnlyState<TStateModel, TResource>>,
  ): Observable<QueryParameters> {
    return MemoizedUtil.select(store, ctor, state => state.queryParameters, true);
  }

  static queryParametersSnapshot<TStateModel extends AssociationStateModel<TResource>
    | AssociationNoSqlReadOnlyStateModel<TResource>
    | AssociationRemoteStateModel<TResource>
    | CompositionStateModel<TResource>
    | Relation2TiersStateModel<TResource>
    | Relation3TiersStateModel<TResource>
    | ResourceStateModel<TResource>
    | ResourceNoSqlReadOnlyStateModel<TResource>
    | ResourceReadOnlyStateModel<TResource>
    , TResource extends BaseResourceType, TRelation extends BaseRelationResourceType>(
    store: Store,
    ctor: Type<AssociationState<TStateModel, TResource>>
      | Type<AssociationNoSqlReadOnlyState<TStateModel, TResource>>
      | Type<AssociationRemoteState<TStateModel, TResource>>
      | Type<CompositionState<TStateModel, TResource>>
      | Type<Relation2TiersState<TStateModel, TResource, TRelation>>
      | Type<Relation3TiersState<TStateModel, TResource, TRelation>>
      | Type<ResourceState<TStateModel, TResource>>
      | Type<ResourceNoSqlReadOnlyState<TStateModel, TResource>>
      | Type<ResourceReadOnlyState<TStateModel, TResource>>,
  ): QueryParameters {
    return MemoizedUtil.selectSnapshot(store, ctor, state => state.queryParameters);
  }
}
