import {ObjectUtil} from "./object.util";

describe("ObjectUtil", () => {
  describe("getNestedValue", () => {
    it("should get nested attribute value when 1 level", () => {
      const object = {
        attribut1: "test",
      };
      expect(ObjectUtil.getNestedValue(object, "attribut1")).toEqual("test");
    });

    it("should get nested attribute value when 2 level", () => {
      const object = {
        attribut1: {
          attribut2: "test",
        },
      };
      expect(ObjectUtil.getNestedValue(object, "attribut1.attribut2")).toEqual("test");
    });

    it("should get nested attribute value when 3 level", () => {
      const object = {
        attribut1: {
          attribut2: {
            attribut3: "test",
          },
        },
      };
      expect(ObjectUtil.getNestedValue(object, "attribut1.attribut2.attribut3")).toEqual("test");
    });

    it("should get default value when invalid key in second part", () => {
      const object = {
        attribut1: {
          attribut2: "test",
        },
      };
      expect(ObjectUtil.getNestedValue(object, "attribut1.wrongAttribut2")).toBeUndefined();
    });

    it("should get default value when invalid key in first part", () => {
      const object = {
        attribut1: {
          attribut2: "test",
        },
      };
      expect(ObjectUtil.getNestedValue(object, "wrongAttribut1.attribut2")).toBeUndefined();
    });

    it("should get default value when object is empty", () => {
      const object = {};
      expect(ObjectUtil.getNestedValue(object, "attribut1.attribut2")).toBeUndefined();
    });

    it("should get default value when object is null", () => {
      const object = null;
      expect(ObjectUtil.getNestedValue(object, "attribut1.attribut2")).toBeUndefined();
    });

    it("should get default value when object is undefined", () => {
      const object = null;
      expect(ObjectUtil.getNestedValue(object, "attribut1.attribut2")).toBeUndefined();
    });

    it("should get default value when key is undefined", () => {
      const object = {
        attribut1: {
          attribut2: "test",
        },
      };
      expect(ObjectUtil.getNestedValue(object, undefined)).toBeUndefined();
    });

    it("should get default value when key is null", () => {
      const object = {
        attribut1: {
          attribut2: "test",
        },
      };
      expect(ObjectUtil.getNestedValue(object, null)).toBeUndefined();
    });

    it("should get default value when key is empty", () => {
      const object = {
        attribut1: {
          attribut2: "test",
        },
      };
      expect(ObjectUtil.getNestedValue(object, "")).toBeUndefined();
    });

    it("should get default value when key is space", () => {
      const object = {
        attribut1: {
          attribut2: "test",
        },
      };
      expect(ObjectUtil.getNestedValue(object, " ")).toBeUndefined();
    });
  });
});
