import {isNumber} from "../tools";

export class NumberUtil {
  static isBetween(value: number,
                   lowerBound: number = -Infinity,
                   upperBound: number = Infinity,
                   orEqualLowerBound?: boolean,
                   orEqualUpperBound: boolean = orEqualLowerBound): boolean {
    if (!isNumber(value) || !isNumber(lowerBound) || !isNumber(upperBound)) {
      return false;
    }
    if (lowerBound > upperBound) {
      return false;
    }
    return (orEqualLowerBound ? value >= lowerBound : value > lowerBound)
      && (orEqualUpperBound ? value <= upperBound : value < upperBound);
  }
}
