import {isTruthyObject} from "../tools";

export class ClipboardUtil {
  static copyStringToClipboard(value: string, doc: Document = document): boolean {
    if (isTruthyObject(doc)) {
      const textareaElement = doc.createElement("textarea");
      textareaElement.value = value;
      textareaElement.setAttribute("readonly", "");
      textareaElement.style.position = "absolute";
      textareaElement.style.opacity = "0";
      textareaElement.style.pointerEvents = "none";
      doc.body.appendChild(textareaElement);
      const selection = doc.getSelection();
      const selectedRange = selection.rangeCount > 0 ? selection.getRangeAt(0) : undefined;
      textareaElement.select();
      textareaElement.setSelectionRange(0, textareaElement.value.length); // For mobile devices
      doc.execCommand("copy");
      doc.body.removeChild(textareaElement);
      if (isTruthyObject(selectedRange)) {
        doc.getSelection().removeAllRanges();
        doc.getSelection().addRange(selectedRange);
      }
      return true;
    }
    return false;
  }
}
