import {isNullOrUndefined} from "../tools";

export class ArrayUtil {
  static distinct<T>(array: T[], key: string | undefined = undefined): T[] {
    const result = [];
    const map = new Map();
    for (const item of array) {
      let mapKey = item;
      if (!isNullOrUndefined(key)) {
        mapKey = item[key];
      }
      if (!map.has(mapKey)) {
        map.set(mapKey, item);
        result.push(item);
      }
    }
    return result;
  }
}
