import {ArrayUtil} from "./array.util";

describe("ArrayUtil", () => {
  describe("distinct", () => {
    it("should remove duplicate 'a'", () => {
      const list = ["a", "b", "a"];
      expect(ArrayUtil.distinct(list)).toEqual(["a", "b"]);
    });

    it("should remove duplicate 2", () => {
      const list = [2, 1, 2, 3];
      expect(ArrayUtil.distinct(list)).toEqual([2, 1, 3]);
    });

    it("should remove duplicate 2", () => {
      const list = [
        {
          id: "test1",
          value: "val1",
        },
        {
          id: "test2",
          value: "val2",
        },
        {
          id: "test1",
          value: "val3",
        }];
      expect(ArrayUtil.distinct(list, "id")).toEqual([
        {
          id: "test1",
          value: "val1",
        },
        {
          id: "test2",
          value: "val2",
        }]);
    });
  });
});
