import {BaseResourceType} from "../../models";
import {CollectionTyped} from "../../models/dto/collection-typed.model";
import {ModelFormControlEvent} from "../../models/forms/model-form-control-event.model";
import {QueryParameters} from "../../models/query-parameters/query-parameters.model";
import {
  BaseAction,
  BaseSubAction,
} from "../../models/stores/base.action";
import {ResourceNameSpace} from "./resource-namespace.model";

export namespace ResourceAction {
  export class LoadResource extends BaseAction {
    static readonly type: string = "[{0}] Load resource";
  }

  export class LoadResourceSuccess extends BaseSubAction<LoadResource> {
    static readonly type: string = "[{0}] Load resource Success";
  }

  export class LoadResourceFail extends BaseSubAction<LoadResource> {
    static readonly type: string = "[{0}] Load resource Fail";
  }

  export class ChangeQueryParameters extends BaseAction {
    static readonly type: string = "[{0}] Change Query Parameters";

    constructor(public queryParameters: QueryParameters, public keepCurrentContext: boolean = false, public getAllAfterChange: boolean = true) {
      super();
    }
  }

  export class GetAll extends BaseAction {
    static readonly type: string = "[{0}] Get All";

    constructor(public queryParameters?: QueryParameters, public keepCurrentContext: boolean = false, public cancelIncomplete: boolean = true) {
      super();
    }
  }

  export class GetAllSuccess<TResource extends BaseResourceType> extends BaseSubAction<GetAll> {
    static readonly type: string = "[{0}] Get All Success";

    constructor(public parentAction: GetAll, public list: CollectionTyped<TResource>) {
      super(parentAction);
    }
  }

  export class GetAllFail<TResource extends BaseResourceType> extends BaseSubAction<GetAll> {
    static readonly type: string = "[{0}] Get All Fail";
  }

  export class GetByListId extends BaseAction {
    static readonly type: string = "[{0}] Get By List Id";

    constructor(public listResId?: string[], public keepCurrentContext: boolean = false, public cancelIncomplete: boolean = true) {
      super();
    }
  }

  export class GetByListIdSuccess extends BaseSubAction<GetAll> {
    static readonly type: string = "[{0}] Get By List Id Success";

    constructor(public parentAction: GetAll) {
      super(parentAction);
    }
  }

  export class GetByListIdFail extends BaseSubAction<GetAll> {
    static readonly type: string = "[{0}] Get By List Id Fail";
  }

  export class GetById extends BaseAction {
    static readonly type: string = "[{0}] Get By Id";

    constructor(public id: string, public keepCurrentContext: boolean = false, public addInListTemp: boolean = false) {
      super();
    }
  }

  export class GetByIdSuccess<TResource extends BaseResourceType> extends BaseSubAction<GetById> {
    static readonly type: string = "[{0}] Get By Id Success";

    constructor(public parentAction: GetById, public model: TResource) {
      super(parentAction);
    }
  }

  export class GetByIdFail<TResource extends BaseResourceType> extends BaseSubAction<GetById> {
    static readonly type: string = "[{0}] Get By Id Fail";
  }

  export class Create<TResource extends BaseResourceType> extends BaseAction {
    static readonly type: string = "[{0}] Create";

    constructor(public modelFormControlEvent: ModelFormControlEvent<TResource>) {
      super();
    }
  }

  export class CreateSuccess<TResource extends BaseResourceType> extends BaseSubAction<Create<TResource>> {
    static readonly type: string = "[{0}] Create Success";

    constructor(public parentAction: Create<TResource>, public model: TResource) {
      super(parentAction);
    }
  }

  export class CreateFail<TResource extends BaseResourceType> extends BaseSubAction<Create<TResource>> {
    static readonly type: string = "[{0}] Create Fail";
  }

  export class Update<TResource extends BaseResourceType> extends BaseAction {
    static readonly type: string = "[{0}] Update";

    constructor(public modelFormControlEvent: ModelFormControlEvent<TResource>) {
      super();
    }
  }

  export class UpdateSuccess<TResource extends BaseResourceType> extends BaseSubAction<Update<TResource>> {
    static readonly type: string = "[{0}] Update Success";

    constructor(public parentAction: Update<TResource>, public model: TResource) {
      super(parentAction);
    }
  }

  export class UpdateFail<TResource extends BaseResourceType> extends BaseSubAction<Update<TResource>> {
    static readonly type: string = "[{0}] Update Fail";
  }

  export class Delete extends BaseAction {
    static readonly type: string = "[{0}] Delete";

    constructor(public resId: string) {
      super();
    }
  }

  export class DeleteSuccess extends BaseSubAction<Delete> {
    static readonly type: string = "[{0}] Delete Success";
  }

  export class DeleteFail extends BaseSubAction<Delete> {
    static readonly type: string = "[{0}] Delete Fail";
  }

  export class AddInList<TResource extends BaseResourceType> extends BaseAction {
    static readonly type: string = "[{0}] Add In List";

    constructor(public model: TResource) {
      super();
    }
  }

  export class AddInListById extends BaseAction {
    static readonly type: string = "[{0}] Add In List By Id";

    constructor(public resId: string, public avoidDuplicate: boolean = false, public replace: boolean = false) {
      super();
    }
  }

  export class AddInListByIdSuccess<TResource extends BaseResourceType> extends BaseSubAction<AddInListById> {
    static readonly type: string = "[{0}] Add In List By Id Success";

    constructor(public parentAction: AddInListById, public model: TResource, public indexAlreadyExisting: number) {
      super(parentAction);
    }
  }

  export class AddInListByIdFail<TResource extends BaseResourceType> extends BaseSubAction<AddInListById> {
    static readonly type: string = "[{0}] Add In List By Id Fail";
  }

  export class RemoveInListById extends BaseAction {
    static readonly type: string = "[{0}] Remove In List By Id";

    constructor(public resId: string) {
      super();
    }
  }

  export class RemoveInListByListId extends BaseAction {
    static readonly type: string = "[{0}] Remove In List By List Id";

    constructor(public listResId: string[]) {
      super();
    }
  }

  export class Clean extends BaseAction {
    static readonly type: string = "[{0}] Clean";

    constructor(public preserveList?: boolean, public queryParameter?: QueryParameters | undefined) {
      super();
    }
  }
}

export const resourceActionNameSpace: ResourceNameSpace = ResourceAction;
