import {RoutesEnum} from "../../enums";
import {BaseOptions} from "../base/base-options.model";
import {ResourceNameSpace} from "./resource-namespace.model";

export interface ResourceOptions extends BaseOptions {
  nameSpace: ResourceNameSpace;
  routeRedirectUrlAfterSuccessCreateAction?: RoutesEnum | undefined | ((resId: string) => string);
  routeRedirectUrlAfterSuccessUpdateAction?: RoutesEnum | undefined | ((resId: string) => string);
  routeRedirectUrlAfterSuccessDeleteAction?: RoutesEnum | undefined | ((resId: string) => string);
  notificationResourceCreateSuccessTextToTranslate?: string;
  notificationResourceUpdateSuccessTextToTranslate?: string;
  notificationResourceDeleteSuccessTextToTranslate?: string;
  notificationResourceCreateFailTextToTranslate?: string;
  notificationResourceUpdateFailTextToTranslate?: string;
  notificationResourceDeleteFailTextToTranslate?: string;
  keepCurrentStateBeforeCreate?: boolean;
  keepCurrentStateAfterCreate?: boolean;
  keepCurrentStateAfterUpdate?: boolean;
  keepCurrentStateAfterDelete?: boolean;
}
