import {BaseResourceType} from "../../models";
import {ResourceReadOnlyNameSpace} from "./resource-read-only-namespace.model";
import {ResourceReadOnlyAction} from "./resource-read-only.action";

export class ResourceReadOnlyActionHelper {
  static changeQueryParameters(resourceReadOnlyNameSpace: ResourceReadOnlyNameSpace, ...args: ConstructorParameters<typeof ResourceReadOnlyAction.ChangeQueryParameters>): ResourceReadOnlyAction.ChangeQueryParameters {
    return new resourceReadOnlyNameSpace.ChangeQueryParameters(...args);
  }

  static getAll(resourceReadOnlyNameSpace: ResourceReadOnlyNameSpace, ...args: ConstructorParameters<typeof ResourceReadOnlyAction.GetAll>): ResourceReadOnlyAction.GetAll {
    return new resourceReadOnlyNameSpace.GetAll(...args);
  }

  static getAllSuccess<TResource extends BaseResourceType>(resourceReadOnlyNameSpace: ResourceReadOnlyNameSpace, ...args: ConstructorParameters<typeof ResourceReadOnlyAction.GetAllSuccess>): ResourceReadOnlyAction.GetAllSuccess<TResource> {
    return new resourceReadOnlyNameSpace.GetAllSuccess(...args);
  }

  static getAllFail(resourceReadOnlyNameSpace: ResourceReadOnlyNameSpace, ...args: ConstructorParameters<typeof ResourceReadOnlyAction.GetAllFail>): ResourceReadOnlyAction.GetAllFail {
    return new resourceReadOnlyNameSpace.GetAllFail(...args);
  }

  static getById(resourceReadOnlyNameSpace: ResourceReadOnlyNameSpace, ...args: ConstructorParameters<typeof ResourceReadOnlyAction.GetById>): ResourceReadOnlyAction.GetById {
    return new resourceReadOnlyNameSpace.GetById(...args);
  }

  static getByIdSuccess<TResource extends BaseResourceType>(resourceReadOnlyNameSpace: ResourceReadOnlyNameSpace, ...args: ConstructorParameters<typeof ResourceReadOnlyAction.GetByIdSuccess>): ResourceReadOnlyAction.GetByIdSuccess<TResource> {
    return new resourceReadOnlyNameSpace.GetByIdSuccess(...args);
  }

  static getByIdFail(resourceReadOnlyNameSpace: ResourceReadOnlyNameSpace, ...args: ConstructorParameters<typeof ResourceReadOnlyAction.GetByIdFail>): ResourceReadOnlyAction.GetByIdFail {
    return new resourceReadOnlyNameSpace.GetByIdFail(...args);
  }
}
