import {BaseResourceType} from "../../models";
import {CollectionTyped} from "../../models/dto/collection-typed.model";
import {QueryParameters} from "../../models/query-parameters/query-parameters.model";
import {
  BaseAction,
  BaseSubAction,
} from "../../models/stores/base.action";
import {ResourceNoSqlReadOnlyNameSpace} from "./resource-no-sql-read-only-namespace.model";

export namespace ResourceNoSqlReadOnlyAction {
  export class ChangeQueryParameters extends BaseAction {
    static readonly type: string = "[{0}] Change Query Parameters";

    constructor(public queryParameters: QueryParameters, public keepCurrentContext: boolean = false) {
      super();
    }
  }

  export class GetAll extends BaseAction {
    static readonly type: string = "[{0}] Resource No Sql ReadOnly : Get All";

    constructor(public queryParameters?: QueryParameters, public keepCurrentContext: boolean = false) {
      super();
    }
  }

  export class GetAllSuccess<TResource extends BaseResourceType> extends BaseSubAction<GetAll> {
    static readonly type: string = "[{0}] Resource No Sql ReadOnly : Get All Success";

    constructor(public parentAction: GetAll, public list: CollectionTyped<TResource>) {
      super(parentAction);
    }
  }

  export class GetAllFail extends BaseSubAction<GetAll> {
    static readonly type: string = "[{0}] Resource No Sql ReadOnly : Get All Fail";
  }

  export class GetById extends BaseAction {
    static readonly type: string = "[{0}] Resource No Sql ReadOnly : Get By Id";

    constructor(public id: string, public keepCurrentContext: boolean = false) {
      super();
    }
  }

  export class GetByIdSuccess<TResource extends BaseResourceType> extends BaseSubAction<GetById> {
    static readonly type: string = "[{0}] Resource No Sql ReadOnly : Get By Id Success";

    constructor(public parentAction: GetById, public model: TResource) {
      super(parentAction);
    }
  }

  export class GetByIdFail extends BaseSubAction<GetById> {
    static readonly type: string = "[{0}] Resource No Sql ReadOnly : Get By Id Fail";
  }
}

export const resourceNoSqlReadOnlyActionNameSpace: ResourceNoSqlReadOnlyNameSpace = ResourceNoSqlReadOnlyAction;
