import {
  BaseAction,
  BaseResourceType,
  BaseSubAction,
} from "../../models";
import {CollectionTyped} from "../../models/dto/collection-typed.model";
import {QueryParameters} from "../../models/query-parameters/query-parameters.model";
import {Relation3TiersForm} from "./relation-3-tiers-form.model";
import {Relation3TiersNameSpace} from "./relation-3-tiers-namespace.model";

export namespace Relation3TiersAction {
  export class GetAll extends BaseAction {
    static readonly type: string = "[{0}] Relation 3 Tiers : Get All";

    constructor(public parentId: string, public queryParameters?: QueryParameters, public keepCurrentContext: boolean = false) {
      super();
    }
  }

  export class GetAllSuccess<TResource extends BaseResourceType> extends BaseSubAction<GetAll> {
    static readonly type: string = "[{0}] Relation 3 Tiers : Get All Success";

    constructor(public parentAction: GetAll, public list: CollectionTyped<TResource>) {
      super(parentAction);
    }
  }

  export class GetAllFail extends BaseSubAction<GetAll> {
    static readonly type: string = "[{0}] Relation 3 Tiers : Get All Fail";
  }

  export class GetById extends BaseAction {
    static readonly type: string = "[{0}] Relation 3 Tiers : Get By Id";

    constructor(public parentId: string, public id: string, public queryParameters?: QueryParameters, public keepCurrentContext: boolean = false) {
      super();
    }
  }

  export class GetByIdSuccess<TResource extends BaseResourceType> extends BaseSubAction<GetById> {
    static readonly type: string = "[{0}] Relation 3 Tiers : Get By Id Success";

    constructor(public parentAction: GetById, public current: TResource) {
      super(parentAction);
    }
  }

  export class GetByIdFail extends BaseSubAction<GetById> {
    static readonly type: string = "[{0}] Relation 3 Tiers : Get By Id Fail";
  }

  export class Create extends BaseAction {
    static readonly type: string = "[{0}] Relation 3 Tiers : Create";

    constructor(public parentId: string, public id: string, public listResId: string[]) {
      super();
    }
  }

  export class CreateSuccess extends BaseSubAction<Create> {
    static readonly type: string = "[{0}] Relation 3 Tiers : Create Success";
  }

  export class CreateFail extends BaseSubAction<Create> {
    static readonly type: string = "[{0}] Relation 3 Tiers : Create Fail";
  }

  export class CreateResource extends BaseAction {
    static readonly type: string = "[{0}] Relation 3 Tiers : Create Resource";

    constructor(public parentId: string, public listResId: string[]) {
      super();
    }
  }

  export class CreateResourceSuccess extends BaseSubAction<CreateResource> {
    static readonly type: string = "[{0}] Relation 3 Tiers : Create Resource Success";
  }

  export class CreateResourceFail extends BaseSubAction<CreateResource> {
    static readonly type: string = "[{0}] Relation 3 Tiers : Create Resource Fail";
  }

  export class Delete extends BaseAction {
    static readonly type: string = "[{0}] Relation 3 Tiers : Delete";

    constructor(public parentId: string, public id: string, public listResId: string[]) {
      super();
    }
  }

  export class DeleteSuccess extends BaseSubAction<Delete> {
    static readonly type: string = "[{0}] Relation 3 Tiers : Delete Success";
  }

  export class DeleteFail extends BaseSubAction<Delete> {
    static readonly type: string = "[{0}] Relation 3 Tiers : Delete Fail";
  }

  export class Update extends BaseAction {
    static readonly type: string = "[{0}] Relation 3 Tiers : Update";

    constructor(public parentId: string, public newForm: Relation3TiersForm[]) {
      super();
    }
  }

  export class UpdateSuccess extends BaseSubAction<Update> {
    static readonly type: string = "[{0}] Relation 3 Tiers : Update Success";

    constructor(public parentAction: Update, public parentId: string) {
      super(parentAction);
    }
  }

  export class UpdateFail extends BaseSubAction<Update> {
    static readonly type: string = "[{0}] Relation 3 Tiers : Update Fail";

    constructor(public parentAction: Update, public parentId: string) {
      super(parentAction);
    }
  }
}

export const relation3TiersActionNameSpace: Relation3TiersNameSpace = Relation3TiersAction;
