import {BaseRelationResourceType} from "../../models/dto/base-relation-resource.model";
import {BaseResourceType} from "../../models/dto/base-resource.model";
import {CollectionTyped} from "../../models/dto/collection-typed.model";
import {QueryParameters} from "../../models/query-parameters/query-parameters.model";
import {
  BaseAction,
  BaseSubAction,
} from "../../models/stores/base.action";
import {Relation2TiersNameSpace} from "./relation-2-tiers-namespace.model";

export namespace Relation2TiersAction {
  export class GetAll extends BaseAction {
    static readonly type: string = "[{0}] Relation 2 Tiers : Get All";

    constructor(public parentId: string, public queryParameters?: QueryParameters, public keepCurrentContext: boolean = false) {
      super();
    }
  }

  export class GetAllSuccess<TResource extends BaseResourceType> extends BaseSubAction<GetAll> {
    static readonly type: string = "[{0}] Relation 2 Tiers : Get All Success";

    constructor(public parentAction: GetAll, public list: CollectionTyped<TResource>) {
      super(parentAction);
    }
  }

  export class GetAllFail extends BaseSubAction<GetAll> {
    static readonly type: string = "[{0}] Relation 2 Tiers : Get All Fail";
  }

  export class GetById extends BaseAction {
    static readonly type: string = "[{0}] Relation 2 Tiers : Get By Id";

    constructor(public parentId: string, public resId: string, public keepCurrentContext: boolean = false) {
      super();
    }
  }

  export class GetByIdSuccess<TResource extends BaseResourceType> extends BaseSubAction<GetById> {
    static readonly type: string = "[{0}] Relation 2 Tiers : Get By Id Success";

    constructor(public parentAction: GetById, public model: TResource) {
      super(parentAction);
    }
  }

  export class GetByIdFail extends BaseSubAction<GetById> {
    static readonly type: string = "[{0}] Relation 2 Tiers : Get By Id Fail";
  }

  export class Create extends BaseAction {
    static readonly type: string = "[{0}] Relation 2 Tiers : Create";

    constructor(public parentId: string, public listResId: string[]) {
      super();
    }
  }

  export class CreateSuccess extends BaseSubAction<Create> {
    static readonly type: string = "[{0}] Relation 2 Tiers : Create Success";
  }

  export class CreateFail extends BaseSubAction<Create> {
    static readonly type: string = "[{0}] Relation 2 Tiers : Create Fail";
  }

  export class DeleteList extends BaseAction {
    static readonly type: string = "[{0}] Relation 2 Tiers : Delete List";

    constructor(public parentId: string, public listResId: string[]) {
      super();
    }
  }

  export class DeleteListSuccess extends BaseSubAction<DeleteList> {
    static readonly type: string = "[{0}] Relation 2 Tiers : Delete ListSuccess";
  }

  export class DeleteListFail extends BaseSubAction<DeleteList> {
    static readonly type: string = "[{0}] Relation 2 Tiers : Delete ListFail";
  }

  export class Delete extends BaseAction {
    static readonly type: string = "[{0}] Relation 2 Tiers : Delete";

    constructor(public parentId: string, public resId: string) {
      super();
    }
  }

  export class DeleteSuccess extends BaseSubAction<Delete> {
    static readonly type: string = "[{0}] Relation 2 Tiers : Delete Success";
  }

  export class DeleteFail extends BaseSubAction<Delete> {
    static readonly type: string = "[{0}] Relation 2 Tiers : Delete Fail";
  }

  export class Update extends BaseAction {
    static readonly type: string = "[{0}] Relation 2 Tiers : Update";

    constructor(public parentId: string, public newResId: string[]) {
      super();
    }
  }

  export class UpdateSuccess extends BaseSubAction<Update> {
    static readonly type: string = "[{0}] Relation 2 Tiers : Update Success";

    constructor(public parentAction: Update, public parentId: string) {
      super(parentAction);
    }
  }

  export class UpdateFail extends BaseSubAction<Update> {
    static readonly type: string = "[{0}] Relation 2 Tiers : Update Fail";

    constructor(public parentAction: Update, public parentId: string) {
      super(parentAction);
    }
  }

  export class UpdateRelation<TRelation extends BaseRelationResourceType> extends BaseAction {
    static readonly type: string = "[{0}] Relation 2 Tiers : Update Relation";

    constructor(public parentId: string, public resId: string, public relation: TRelation) {
      super();
    }
  }

  export class UpdateRelationSuccess<TRelation extends BaseRelationResourceType> extends BaseSubAction<UpdateRelation<TRelation>> {
    static readonly type: string = "[{0}] Relation 2 Tiers : Update Relation Success";

    constructor(public parentAction: UpdateRelation<TRelation>) {
      super(parentAction);
    }
  }

  export class UpdateRelationFail<TRelation extends BaseRelationResourceType> extends BaseSubAction<UpdateRelation<TRelation>> {
    static readonly type: string = "[{0}] Relation 2 Tiers : Update Relation Fail";

    constructor(public parentAction: UpdateRelation<TRelation>) {
      super(parentAction);
    }
  }
}

export const relation2TiersActionNameSpace: Relation2TiersNameSpace = Relation2TiersAction;
