import {
  BaseAction,
  BaseResourceType,
  BaseSubAction,
} from "../../models";
import {CollectionTyped} from "../../models/dto/collection-typed.model";
import {QueryParameters} from "../../models/query-parameters/query-parameters.model";
import {CompositionNameSpace} from "./composition-namespace.model";

export namespace CompositionAction {
  export class ChangeQueryParameters extends BaseAction {
    static readonly type: string = "[{0}] Change Query Parameters";

    constructor(public parentId: string, public queryParameters: QueryParameters, public keepCurrentContext: boolean = false, public getAllAfterChange: boolean = true) {
      super();
    }
  }

  export class GetAll extends BaseAction {
    static readonly type: string = "[{0}] Composition : Get All SubResource";

    constructor(public parentId: string, public queryParameters?: QueryParameters, public keepCurrentContext: boolean = false) {
      super();
    }
  }

  export class GetAllSuccess<TResource extends BaseResourceType> extends BaseSubAction<GetAll> {
    static readonly type: string = "[{0}] Composition : Get All SubResource Success";

    constructor(public parentAction: GetAll, public list: CollectionTyped<TResource>) {
      super(parentAction);
    }
  }

  export class GetAllFail extends BaseSubAction<GetAll> {
    static readonly type: string = "[{0}] Composition : Get All SubResource Fail";
  }

  export class GetById extends BaseAction {
    static readonly type: string = "[{0}] Composition : Get By Id";

    constructor(public parentId: string, public resId: string, public keepCurrentContext: boolean = false) {
      super();
    }
  }

  export class GetByIdSuccess<TResource extends BaseResourceType> extends BaseSubAction<GetById> {
    static readonly type: string = "[{0}] Composition : Get By Id Success";

    constructor(public parentAction: GetById, public model: TResource) {
      super(parentAction);
    }
  }

  export class GetByIdFail extends BaseSubAction<GetById> {
    static readonly type: string = "[{0}] Composition : Get By Id Fail";
  }

  export class Create<TResource extends BaseResourceType> extends BaseAction {
    static readonly type: string = "[{0}] Composition : Create SubResource";

    constructor(public parentId: string, public model: TResource) {
      super();
    }
  }

  export class CreateSuccess<TResource extends BaseResourceType> extends BaseSubAction<Create<TResource>> {
    static readonly type: string = "[{0}] Composition : Create SubResource Success";

    constructor(public parentAction: Create<TResource>, public parentId: string) {
      super(parentAction);
    }
  }

  export class CreateFail<TResource extends BaseResourceType> extends BaseSubAction<Create<TResource>> {
    static readonly type: string = "[{0}] Composition : Create SubResource Fail";
  }

  export class Delete<TResource extends BaseResourceType> extends BaseAction {
    static readonly type: string = "[{0}] Composition : Delete SubResource";

    constructor(public parentId: string, public model: TResource) {
      super();
    }
  }

  export class DeleteSuccess<TResource extends BaseResourceType> extends BaseSubAction<Delete<TResource>> {
    static readonly type: string = "[{0}] Composition : Delete SubResource Success";

    constructor(public parentAction: Delete<TResource>, public parentId: string) {
      super(parentAction);
    }
  }

  export class DeleteFail<TResource extends BaseResourceType> extends BaseSubAction<Delete<TResource>> {
    static readonly type: string = "[{0}] Composition : Delete SubResource Fail";
  }

  export class Update<TResource extends BaseResourceType> extends BaseAction {
    static readonly type: string = "[{0}] Composition : Update SubResource";

    constructor(public parentId: string, public model: TResource) {
      super();
    }
  }

  export class UpdateSuccess<TResource extends BaseResourceType> extends BaseSubAction<Update<TResource>> {
    static readonly type: string = "[{0}] Composition : Update SubResource Success";

    constructor(public parentAction: Update<TResource>, public parentId: string) {
      super(parentAction);
    }
  }

  export class UpdateFail<TResource extends BaseResourceType> extends BaseSubAction<Update<TResource>> {
    static readonly type: string = "[{0}] Composition : Update SubResource Fail";

    constructor(public parentAction: Update<TResource>, public parentId: string) {
      super(parentAction);
    }
  }
}

export const compositionActionNameSpace: CompositionNameSpace = CompositionAction;
