import {BaseResourceType} from "../../models";
import {CompositionNameSpace} from "./composition-namespace.model";
import {CompositionAction} from "./composition.action";

export class CompositionActionHelper {
  static changeQueryParameters(compositionNameSpace: CompositionNameSpace, ...args: ConstructorParameters<typeof CompositionAction.ChangeQueryParameters>): CompositionAction.ChangeQueryParameters {
    return new compositionNameSpace.ChangeQueryParameters(...args);
  }

  static getAll(compositionNameSpace: CompositionNameSpace, ...args: ConstructorParameters<typeof CompositionAction.GetAll>): CompositionAction.GetAll {
    return new compositionNameSpace.GetAll(...args);
  }

  static getAllSuccess<TResource extends BaseResourceType>(compositionNameSpace: CompositionNameSpace, ...args: ConstructorParameters<typeof CompositionAction.GetAllSuccess>): CompositionAction.GetAllSuccess<TResource> {
    return new compositionNameSpace.GetAllSuccess(...args);
  }

  static getAllFail(compositionNameSpace: CompositionNameSpace, ...args: ConstructorParameters<typeof CompositionAction.GetAllFail>): CompositionAction.GetAllFail {
    return new compositionNameSpace.GetAllFail(...args);
  }

  static getById(compositionNameSpace: CompositionNameSpace, ...args: ConstructorParameters<typeof CompositionAction.GetById>): CompositionAction.GetById {
    return new compositionNameSpace.GetById(...args);
  }

  static getByIdSuccess<TResource extends BaseResourceType>(compositionNameSpace: CompositionNameSpace, ...args: ConstructorParameters<typeof CompositionAction.GetByIdSuccess>): CompositionAction.GetByIdSuccess<TResource> {
    return new compositionNameSpace.GetByIdSuccess(...args);
  }

  static getByIdFail(compositionNameSpace: CompositionNameSpace, ...args: ConstructorParameters<typeof CompositionAction.GetByIdFail>): CompositionAction.GetByIdFail {
    return new compositionNameSpace.GetByIdFail(...args);
  }

  static create<TResource extends BaseResourceType>(compositionNameSpace: CompositionNameSpace, ...args: ConstructorParameters<typeof CompositionAction.Create>): CompositionAction.Create<TResource> {
    return new compositionNameSpace.Create(...args);
  }

  static createSuccess<TResource extends BaseResourceType>(compositionNameSpace: CompositionNameSpace, ...args: ConstructorParameters<typeof CompositionAction.CreateSuccess>): CompositionAction.CreateSuccess<TResource> {
    return new compositionNameSpace.CreateSuccess(...args);
  }

  static createFail<TResource extends BaseResourceType>(compositionNameSpace: CompositionNameSpace, ...args: ConstructorParameters<typeof CompositionAction.CreateFail>): CompositionAction.CreateFail<TResource> {
    return new compositionNameSpace.CreateFail(...args);
  }

  static delete<TResource extends BaseResourceType>(compositionNameSpace: CompositionNameSpace, ...args: ConstructorParameters<typeof CompositionAction.Delete>): CompositionAction.Delete<TResource> {
    return new compositionNameSpace.Delete(...args);
  }

  static deleteSuccess<TResource extends BaseResourceType>(compositionNameSpace: CompositionNameSpace, ...args: ConstructorParameters<typeof CompositionAction.DeleteSuccess>): CompositionAction.DeleteSuccess<TResource> {
    return new compositionNameSpace.DeleteSuccess(...args);
  }

  static deleteFail<TResource extends BaseResourceType>(compositionNameSpace: CompositionNameSpace, ...args: ConstructorParameters<typeof CompositionAction.DeleteFail>): CompositionAction.DeleteFail<TResource> {
    return new compositionNameSpace.DeleteFail(...args);
  }

  static update<TResource extends BaseResourceType>(compositionNameSpace: CompositionNameSpace, ...args: ConstructorParameters<typeof CompositionAction.Update>): CompositionAction.Update<TResource> {
    return new compositionNameSpace.Update(...args);
  }

  static updateSuccess<TResource extends BaseResourceType>(compositionNameSpace: CompositionNameSpace, ...args: ConstructorParameters<typeof CompositionAction.UpdateSuccess>): CompositionAction.UpdateSuccess<TResource> {
    return new compositionNameSpace.UpdateSuccess(...args);
  }

  static updateFail<TResource extends BaseResourceType>(compositionNameSpace: CompositionNameSpace, ...args: ConstructorParameters<typeof CompositionAction.UpdateFail>): CompositionAction.UpdateFail<TResource> {
    return new compositionNameSpace.UpdateFail(...args);
  }
}
