import {BaseStateModel} from "../../models";
import {StoreUtil} from "../../utils/stores/store.util";

export abstract class BasicState<TStateModel extends BaseStateModel> {
  protected readonly _state: TStateModel;
  protected readonly _stateName: string;

  get stateName(): string {
    return this._stateName;
  }

  protected constructor() {
    this._state = StoreUtil.getStateFromInstance(this);
    this._stateName = StoreUtil.getStateNameFromInstance(this);
  }
}
