import {
  Actions,
  Store,
} from "@ngxs/store";
import {ApiService} from "../../http/api.service";
import {
  BaseStateModel,
  BaseStoreNameSpace,
} from "../../models";
import {NotifierService} from "../../models/services/notifier-service.model";
import {isNullOrUndefined} from "../../tools";
import {StoreUtil} from "../../utils/stores/store.util";
import {BaseOptions} from "./base-options.model";
import {BasicState} from "./basic.state";

export const defaultBaseStateInitValue: () => BaseStateModel = () =>
  ({
    isLoadingCounter: 0,
  });

export abstract class BaseState<TStateModel extends BaseStateModel> extends BasicState<TStateModel> {
  protected abstract get _urlResource(): string;

  protected readonly _state: TStateModel;
  protected readonly _stateName: string;
  protected readonly _nameSpace: BaseStoreNameSpace;

  get stateName(): string {
    return this._stateName;
  }

  protected constructor(protected apiService: ApiService,
                        protected store: Store,
                        protected notifierService: NotifierService,
                        protected actions$: Actions,
                        protected options: BaseOptions,
                        protected baseStateConstructor: typeof BaseState | any) {
    super();
    this.options = Object.assign(baseStateConstructor.getDefaultOptions(), options);
    baseStateConstructor.checkOptions(this._stateName, this.options);
    this._state = StoreUtil.getStateFromInstance(this);
    this._stateName = StoreUtil.getStateNameFromInstance(this);
    this._nameSpace = options.nameSpace;
    StoreUtil.initState(baseStateConstructor, this.constructor, this._nameSpace);
  }

  // @InheritedSelector()
  // static isLoading(state: BaseStateModel): boolean {
  //   return StoreUtil.isLoadingState(state);
  // }

  protected static getDefaultOptions(): BaseOptions | any {
    return {};
  }

  protected static checkOptions(stateName: string, options: BaseOptions): void {
    const errorMessage = `Invalid options for resource state '${stateName}':`;
    if (isNullOrUndefined(options.nameSpace)) {
      throw new Error(`${errorMessage} resourceNameSpace should be defined`);
    }
  }
}
