import {BaseResourceType} from "../../models";
import {CollectionTyped} from "../../models/dto/collection-typed.model";
import {QueryParameters} from "../../models/query-parameters/query-parameters.model";
import {
  BaseAction,
  BaseSubAction,
} from "../../models/stores/base.action";
import {AssociationNameSpace} from "./association-namespace.model";

export namespace AssociationAction {
  export class GetAll extends BaseAction {
    static readonly type: string = "[{0}] Association : Get All";

    constructor(public parentId: string, public queryParameters?: QueryParameters, public keepCurrentContext: boolean = false) {
      super();
    }
  }

  export class GetAllSuccess<TResource extends BaseResourceType> extends BaseSubAction<GetAll> {
    static readonly type: string = "[{0}] Association : Get All Success";

    constructor(public parentAction: GetAll, public list: CollectionTyped<TResource>) {
      super(parentAction);
    }
  }

  export class GetAllFail extends BaseSubAction<GetAll> {
    static readonly type: string = "[{0}] Association : Get All Fail";
  }

  export class GetById extends BaseAction {
    static readonly type: string = "[{0}] Association : Get By Id";

    constructor(public parentId: string, public resId: string, public keepCurrentContext: boolean = false) {
      super();
    }
  }

  export class GetByIdSuccess<TResource extends BaseResourceType> extends BaseSubAction<GetById> {
    static readonly type: string = "[{0}] Association : Get By Id Success";

    constructor(public parentAction: GetById, public model: TResource) {
      super(parentAction);
    }
  }

  export class GetByIdFail extends BaseSubAction<GetById> {
    static readonly type: string = "[{0}] Association : Get By Id Fail";
  }

  export class Create extends BaseAction {
    static readonly type: string = "[{0}] Association : Create";

    constructor(public parentId: string, public listResId: string[]) {
      super();
    }
  }

  export class CreateSuccess extends BaseSubAction<Create> {
    static readonly type: string = "[{0}] Association : Create Success";
  }

  export class CreateFail extends BaseSubAction<Create> {
    static readonly type: string = "[{0}] Association : Create Fail";
  }

  export class Delete extends BaseAction {
    static readonly type: string = "[{0}] Association : Delete";

    constructor(public parentId: string, public resId: string) {
      super();
    }
  }

  export class DeleteSuccess extends BaseSubAction<Delete> {
    static readonly type: string = "[{0}] Association : Delete Success";
  }

  export class DeleteFail extends BaseSubAction<Delete> {
    static readonly type: string = "[{0}] Association : Delete Fail";
  }

  export class DeleteList extends BaseAction {
    static readonly type: string = "[{0}] Association : Delete List";

    constructor(public parentId: string, public listResId: string[]) {
      super();
    }
  }

  export class DeleteListSuccess extends BaseSubAction<DeleteList> {
    static readonly type: string = "[{0}] Association : Delete  List Success";
  }

  export class DeleteListFail extends BaseSubAction<DeleteList> {
    static readonly type: string = "[{0}] Association : Delete  List Fail";
  }

  export class Update extends BaseAction {
    static readonly type: string = "[{0}] Association : Update";

    constructor(public parentId: string, public newResId: string[]) {
      super();
    }
  }

  export class UpdateSuccess extends BaseSubAction<Update> {
    static readonly type: string = "[{0}] Association : Update Success";

    constructor(public parentAction: Update, public parentId: string) {
      super(parentAction);
    }
  }

  export class UpdateFail extends BaseSubAction<Update> {
    static readonly type: string = "[{0}] Association : Update Fail";

    constructor(public parentAction: Update, public parentId: string) {
      super(parentAction);
    }
  }
}

export const associationActionNameSpace: AssociationNameSpace = AssociationAction;
