import {NgModule} from "@angular/core";
import {SolidifyEmptyContainer} from "./components/empty-container/solidify-empty.container";
import {FocusFirstElementDirective} from "./directives/autofocus/focus-first-element.directive";
import {ShortcutDirective} from "./directives/shortcut/shortcut.directive";
import {SolidifyValidationDirective} from "./directives/validation/solidify-validation.directive";
import {isPipes} from "./pipes/shared-is-pipes/is-pipes.model";

const routables = [];
const containers = [SolidifyEmptyContainer];
const presentationals = [];
const directives = [
  SolidifyValidationDirective,
  ShortcutDirective,
  FocusFirstElementDirective,
];
const pipes = [
  ...isPipes,
];
const modules = [];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...presentationals,
    ...directives,
    ...pipes,
  ],
  entryComponents: [],
  imports: [
    ...modules,
  ],
  exports: [
    ...routables,
    ...containers,
    ...presentationals,
    ...directives,
    ...pipes,
    ...modules,
  ],
  providers: [],
})
export class SolidifyFrontendModule {
}
