import {HttpErrorResponse} from "@angular/common/http";
import {
  Inject,
  Injectable,
} from "@angular/core";
import {TranslateService} from "@ngx-translate/core";
import {DefaultSolidifyEnvironment} from "../environments";
import {ErrorHelper} from "../helpers";
import {ENVIRONMENT} from "../injection-tokens";
import {HttpStatus} from "../lib-wrapped/http-status-code.model";

@Injectable({
  providedIn: "root",
})
export class ErrorService {
  constructor(private translate: TranslateService,
              @Inject(ENVIRONMENT) private environment: DefaultSolidifyEnvironment) {
  }

  getClientMessage(error: Error): string {
    if (!navigator.onLine) {
      return this.translate.instant(this.environment.notificationHttpOfflineToTranslate);
    }
    return error.message ? error.message : error.toString();
  }

  getClientStack(error: Error): string {
    return error.stack;
  }

  getServerMessage(error: HttpErrorResponse): string {
    if (error.status === HttpStatus.FORBIDDEN) {
      return this.translate.instant(this.environment.notificationHttpForbiddenToTranslate);
    }
    if (error.status === HttpStatus.UNAUTHORIZED) {
      if (error.error.error === ErrorHelper.INVALID_TOKEN_ERROR) {
        return this.translate.instant(this.environment.notificationHttpInvalidTokenToTranslate);
      } else {
        return this.translate.instant(this.environment.notificationHttpUnauthorizedToTranslate);
      }
    }
    if (error.status === HttpStatus.NOT_FOUND) {
      return this.translate.instant(this.environment.notificationHttpNotFoundToTranslate);
    }
    return error.message;
  }

  getServerStack(error: HttpErrorResponse): string {
    return error.message;
  }
}
