import {IsNonEmptyStringPipe} from "./is-non-empty-string.pipe";

describe("IsNonEmptyStringPipe", () => {
  it("create an instance", () => {
    const pipe = new IsNonEmptyStringPipe();
    expect(pipe).toBeTruthy();
  });

  it("assert that value is non empty when equal 'test'", () => {
    const pipe = new IsNonEmptyStringPipe();
    expect(pipe.transform("test")).toBe(true);
  });

  it("assert that value is empty when equal ''", () => {
    const pipe = new IsNonEmptyStringPipe();
    expect(pipe.transform("")).toBe(false);
  });

  it("assert that value is empty when equal null", () => {
    const pipe = new IsNonEmptyStringPipe();
    expect(pipe.transform(null)).toBe(false);
  });

  it("assert that value is empty when equal undefined", () => {
    const pipe = new IsNonEmptyStringPipe();
    expect(pipe.transform(undefined)).toBe(false);
  });
});
