import {IsNonEmptyArrayPipe} from "./is-non-empty-array.pipe";

describe("IsNonEmptyArrayPipe", () => {
  it("create an instance", () => {
    const pipe = new IsNonEmptyArrayPipe();
    expect(pipe).toBeTruthy();
  });

  it("assert that value is non empty array when equal ['test']", () => {
    const pipe = new IsNonEmptyArrayPipe();
    expect(pipe.transform(["test"])).toBe(true);
  });

  it("assert that value is empty array when equal []", () => {
    const pipe = new IsNonEmptyArrayPipe();
    expect(pipe.transform([])).toBe(false);
  });

  it("assert that value is empty array when equal null", () => {
    const pipe = new IsNonEmptyArrayPipe();
    expect(pipe.transform(null)).toBe(false);
  });

  it("assert that value is empty array when equal undefined", () => {
    const pipe = new IsNonEmptyArrayPipe();
    expect(pipe.transform(undefined)).toBe(false);
  });
});
