import {IsFunctionPipe} from "./is-function.pipe";

describe("IsFunctionPipe", () => {
  function add(x: number, y: number): number {
    return x + y;
  }

  it("create an instance", () => {
    const pipe = new IsFunctionPipe();
    expect(pipe).toBeTruthy();
  });

  it("assert that value is a function", () => {
    const pipe = new IsFunctionPipe();

    expect(pipe.transform(add(2, 3))).toBe(false);
  });

  it("assert that value is not a function", () => {
    const pipe = new IsFunctionPipe();
    expect(pipe.transform(false)).toBe(false);
  });

});
