import {ActionCompletion} from "@ngxs/store";
import {Observable} from "rxjs";

export abstract class BaseAction {

  parentAction?: BaseAction | undefined;

  withParentAction(parentAction: BaseAction | undefined): this {
    this.parentAction = parentAction;
    return this;
  }

}

export abstract class BaseSubAction<TParent extends BaseAction> extends BaseAction {

  constructor(parentAction: TParent) {
    super();
    this.parentAction = parentAction;
  }

}

export interface ActionSubActionCompletionsWrapper<T extends BaseAction = BaseAction> {
  action: T;
  subActionCompletions?: Observable<ActionCompletion<BaseSubAction<T>, Error>>[] | undefined;
}
