import {InjectionToken} from "@angular/core";
import {AbstractSnackbarPresentational} from "../../components";
import {NotificationTypeEnum} from "../../enums";

export abstract class SnackBarModel {
  abstract open(message: string, action?: string, config?: any): any;

  abstract openFromComponent(component: any, config?: any): any;

  abstract dismiss(): void;
}

export interface SnackbarOption {
  data: SnackbarData | any;
  component?: AbstractSnackbarPresentational;
  durationInSecond: number;
}

export interface SnackbarData {
  message: string;
  messageParam: Object | undefined;
  category: NotificationTypeEnum;
}

export const SNACK_BAR: InjectionToken<any> = new InjectionToken("snackbar");
