import {Paging} from "./paging.model";
import {Search} from "./search.model";
import {Sort} from "./sort.model";

export interface QueryParameters {
  sort?: Sort;
  paging?: Paging;
  search?: Search;
}

export class QueryParameters implements QueryParameters {
  constructor(defaultPageSize?: number) {
    this.paging = new Paging(defaultPageSize);
    this.search = new Search();
  }
}
