export interface Paging {
  /** The current page index. */
  pageIndex: number;
  /** The number of items per page */
  pageSize: number;
  /** The current total number of items being paged */
  length: number;
}

export class Paging implements Paging {
  constructor(defaultPageSize: number = 10) {
    this.pageSize = defaultPageSize;
    this.pageIndex = 0;
    this.length = 0;
  }
}
