import {BehaviorSubject} from "rxjs";
import {isNumberReal} from "../../tools/is/is.tool";

export class CounterSubject extends BehaviorSubject<number> {

  private static _toSafeValue(value: any): number {
    return isNumberReal(value) && value >= 0 ? value : 0;
  }

  constructor(initialCount: number = 0) {
    super(CounterSubject._toSafeValue(initialCount));
  }

  next(count: any): void {
    super.next(CounterSubject._toSafeValue(parseFloat(count)));
  }

  hasCount(): boolean {
    return this.getValue() > 0;
  }

  increment(increment: number = 1): number {
    const result = this.getValue() + parseFloat(increment as any);
    this.next(result);
    return result;
  }

  decrement(decrement: number = 1): number {
    const result = this.getValue() - parseFloat(decrement as any);
    this.next(result);
    return result;
  }

}
