import {
  HTTP_INTERCEPTORS,
  HttpRequest,
  HttpResponse,
} from "@angular/common/http";
import {HttpClientTestingModule} from "@angular/common/http/testing";
import {TestBed} from "@angular/core/testing";
import {EMPTY} from "rxjs";
import {OAuthStorage} from "../auth/types";
import {ENVIRONMENT} from "../injection-tokens";

import {OAuth2Interceptor} from "./oauth2-interceptor.service";

describe("OAuth2Interceptor", () => {

  beforeEach(() => {
    TestBed.configureTestingModule({
      imports: [HttpClientTestingModule],
      providers: [
        {
          provide: HTTP_INTERCEPTORS,
          useClass: OAuth2Interceptor,
          multi: true,
        },
        {
          provide: OAuthStorage,
          useValue: sessionStorage,
        },
        {
          provide: ENVIRONMENT,
          useValue: {
            allowedUrls: [],
            sendAccessToken: true,
          },
        },
      ],
    });
  });

  it("should be created", () => {
    const service: OAuth2Interceptor = TestBed.get(OAuth2Interceptor);
    expect(service).toBeTruthy();
  });

  it("should set header authorization", () => {
    const token: string = "token_value";
    const service: OAuth2Interceptor = TestBed.get(OAuth2Interceptor);
    spyOn(sessionStorage, "getItem").and.returnValue(token);
    let response: HttpResponse<any>;
    const next: any = {
      handle: responseHandle => {
        response = responseHandle;
        return EMPTY;
      },
    };
    const request: HttpRequest<any> = new HttpRequest<any>("GET", "/api/deposits");
    service.intercept(request, next);
    expect(response.headers.get("Authorization")).toEqual("Bearer " + token);
  });

});
