import {Injectable} from "@angular/core";

/**
 * Represents the response from the user info endpoint
 * http://openid.net/specs/openid-connect-core-1_0.html#UserInfo
 */
export interface UserInfo {
  sub: string;

  [key: string]: any;
}

/**
 * Represents an OpenID Connect discovery document
 */
export interface OidcDiscoveryDoc {
  issuer: string;
  authorization_endpoint: string;
  token_endpoint: string;
  token_endpoint_auth_methods_supported: string[];
  token_endpoint_auth_signing_alg_values_supported: string[];
  userinfo_endpoint: string;
  check_session_iframe: string;
  end_session_endpoint: string;
  jwks_uri: string;
  registration_endpoint: string;
  scopes_supported: string[];
  response_types_supported: string[];
  acr_values_supported: string[];
  response_modes_supported: string[];
  grant_types_supported: string[];
  subject_types_supported: string[];
  userinfo_signing_alg_values_supported: string[];
  userinfo_encryption_alg_values_supported: string[];
  userinfo_encryption_enc_values_supported: string[];
  id_token_signing_alg_values_supported: string[];
  id_token_encryption_alg_values_supported: string[];
  id_token_encryption_enc_values_supported: string[];
  request_object_signing_alg_values_supported: string[];
  display_values_supported: string[];
  claim_types_supported: string[];
  claims_supported: string[];
  claims_parameter_supported: boolean;
  service_documentation: string;
  ui_locales_supported: string[];
}

@Injectable({
  providedIn: "root",
})
export class UrlHelperService {
  public getHashFragmentParams(customHashFragment?: string): object {
    let hash = customHashFragment || window.location.hash;

    hash = decodeURIComponent(hash);

    if (hash.indexOf("#") !== 0) {
      return {};
    }

    const questionMarkPosition = hash.indexOf("?");

    if (questionMarkPosition > -1) {
      hash = hash.substr(questionMarkPosition + 1);
    } else {
      hash = hash.substr(1);
    }

    return this.parseQueryString(hash);
  }

  public parseQueryString(queryString: string): object {
    const data = {};
    let pairs;
    let pair;
    let separatorIndex;
    let escapedKey;
    let escapedValue;
    let key;
    let value;

    if (queryString === null) {
      return data;
    }

    pairs = queryString.split("&");

    // tslint:disable-next-line:prefer-for-of
    for (let i = 0; i < pairs.length; i++) {
      pair = pairs[i];
      separatorIndex = pair.indexOf("=");

      if (separatorIndex === -1) {
        escapedKey = pair;
        escapedValue = null;
      } else {
        escapedKey = pair.substr(0, separatorIndex);
        escapedValue = pair.substr(separatorIndex + 1);
      }

      key = decodeURIComponent(escapedKey);
      value = decodeURIComponent(escapedValue);

      if (key.substr(0, 1) === "/") {
        key = key.substr(1);
      }

      data[key] = value;
    }

    return data;
  }
}
