import {HttpErrorResponse} from "@angular/common/http";
import {HttpStatus} from "../lib-wrapped/http-status-code.model";
import {
  ErrorDto,
  ValidationErrorDto,
} from "../models/errors/error-dto.model";
import {
  isNonEmptyArray,
  isNotNullNorUndefined,
  isNullOrUndefined,
} from "../tools";

export class ErrorHelper {
  static readonly VALIDATION_ERROR_MESSAGE: string = "Validation failed";
  static readonly INVALID_TOKEN_ERROR: string = "invalid_token";

  static extractValidationErrors(error: Error | HttpErrorResponse): ValidationErrorDto[] {
    if (!(error instanceof HttpErrorResponse) || !ErrorHelper.isValidationErrors(error.error)) {
      return [];
    }

    return error.error.validationErrors;
  }

  static isValidationErrors(value: any): value is ErrorDto {
    return isNotNullNorUndefined(value as ErrorDto) && (value as ErrorDto).statusCode === HttpStatus.BAD_REQUEST && (value as ErrorDto).message === this.VALIDATION_ERROR_MESSAGE;
  }

  static isErrorToTreat(error: HttpErrorResponse, httpErrorKeyToSkipInErrorHandler: string[]): boolean {
    const errorDto = error.error as ErrorDto;
    return !ErrorHelper.isValidationErrors(error.error)
      && isNonEmptyArray(httpErrorKeyToSkipInErrorHandler)
      && !isNullOrUndefined(errorDto)
      && !httpErrorKeyToSkipInErrorHandler.includes(errorDto.message);
  }
}
