import {BaseStateModel} from "../models";
import {BaseState} from "../stores/base";
import {isTruthyObject} from "../tools";
import {SolidifyError} from "./solidify.error";

export class SolidifyStateError<TState extends BaseState<TStateModel>, TStateModel extends BaseStateModel> extends SolidifyError {

  constructor(public state: TState,
              nativeError?: Error) {
    super("Solidify State Error", nativeError);
  }

  getStateName(): string | undefined {
    return isTruthyObject(this.state) ? this.state.stateName : undefined;
  }
}
