import {
  Directive,
  EventEmitter,
  HostListener,
  Output,
} from "@angular/core";
import {Observable} from "rxjs";

@Directive({
  selector: "[solidifyShortCuts]",
})
export class ShortcutDirective {

  private readonly _onEscapeEventEmitter: EventEmitter<KeyboardEvent> = new EventEmitter<KeyboardEvent>();

  @Output("onEscape")
  readonly escapeObs: Observable<KeyboardEvent> = this._onEscapeEventEmitter.asObservable();

  private readonly _onEnterEventEmitter: EventEmitter<KeyboardEvent> = new EventEmitter<KeyboardEvent>();

  @Output("onEnter")
  readonly enterObs: Observable<KeyboardEvent> = this._onEnterEventEmitter.asObservable();

  @HostListener("keydown.escape", ["$event"])
  onEscape(keyboardEvent: KeyboardEvent): void {
    if (keyboardEvent && !keyboardEvent.defaultPrevented) {
      keyboardEvent.preventDefault();
      this._onEscapeEventEmitter.emit(keyboardEvent);
    }
  }

  @HostListener("keydown.enter", ["$event"])
  onEnter(keyboardEvent: KeyboardEvent): void {
    if (keyboardEvent && !keyboardEvent.defaultPrevented) {
      keyboardEvent.preventDefault();
      this._onEnterEventEmitter.emit(keyboardEvent);
    }
  }

}
