import {DOCUMENT} from "@angular/common";
import {
  Directive,
  ElementRef,
  Inject,
  Input,
} from "@angular/core";

@Directive({
  selector: "[solidifyFocusFirstElement]",
})
export class FocusFirstElementDirective {

  private _focusFirstElement: boolean = false;

  @Input("solidifyFocusFirstElement")
  set focusFirstElement(focusFirstElement: boolean) {
    if (this._focusFirstElement !== focusFirstElement) {
      this._focusFirstElement = focusFirstElement;
      this.onFocusFirstElementChange();
    }

  }

  get focusFirstElement(): boolean {
    return this._focusFirstElement;
  }

  get nativeElement(): HTMLElement {
    return this._elementRef.nativeElement;
  }

  get document(): Document {
    return this._document;
  }

  public constructor(private readonly _elementRef: ElementRef,
                     @Inject(DOCUMENT) private readonly _document: any) {
  }

  onFocusFirstElementChange(): void {
    if (this._focusFirstElement) {
      this.doFocusFirstElement();
    }
  }

  doFocusFirstElement(needToFocusFirstElement: boolean = this.focusFirstElement): void {
      setTimeout(() => {
        let hasFocused = false;
        this.nativeElement.querySelectorAll("*").forEach((elementToFocus: HTMLElement) => {
          if (!hasFocused) {
            elementToFocus.focus();
            if (this.document.activeElement === elementToFocus) {
              hasFocused = true;
            }
          }
        });
      });
  }

}
