import {ActionOptions} from "@ngxs/store";
import {BaseStoreNameSpace} from "../models/stores/base-store-namespace.model";
import {StoreActionClass} from "../models/stores/state-action.model";
import {isNullOrUndefined} from "../tools";
import {
  SolidifyMetaDataModel,
  SolidifyMetadataUtil,
} from "../utils/stores/solidify-metadata.util";

export function RegisterDefaultAction<T extends BaseStoreNameSpace>(defaultActionClassCallback: DefaultActionClassCallback<T>, options?: ActionOptions, parentState?: any): MethodDecorator {
  return (target: any, name: string, descriptor: TypedPropertyDescriptor<any>) => {
    let meta: SolidifyMetaDataModel<T>;
    if (isNullOrUndefined(parentState)) {
      meta = SolidifyMetadataUtil.ensureStoreSolidifyMetadata(target.constructor);
    } else {
      meta = SolidifyMetadataUtil.ensureStoreSolidifyMetadata(parentState);
    }
    if (!Array.isArray(meta.defaultActions)) {
      meta.defaultActions = [];
    }

    meta.defaultActions.push({
      fn: name,
      callback: defaultActionClassCallback,
      options,
    });
  };
}

export function OverrideDefaultAction(): MethodDecorator {
  return (target: any, name: string, descriptor: TypedPropertyDescriptor<any>) => {
    const meta = SolidifyMetadataUtil.ensureStoreSolidifyMetadata(target.constructor);
    if (!Array.isArray(meta.excludedRegisteredDefaultActionFns)) {
      meta.excludedRegisteredDefaultActionFns = [];
    }
    meta.excludedRegisteredDefaultActionFns.push(name);
  };
}

export interface RegisteredDefaultAction<T extends BaseStoreNameSpace> {
  fn?: string;
  callback?: DefaultActionClassCallback<T>;
  options?: ActionOptions;
}

export type DefaultActionClassCallback<T extends BaseStoreNameSpace> = (baseNameSpace?: T) => StoreActionClass;
