import {ActionOptions} from "@ngxs/store";
import {
  SOLIDIFY_META_KEY,
  SolidifyMetadataUtil,
} from "../utils";
import {
  OverrideDefaultAction,
  RegisterDefaultAction,
} from "./store.decorator";

describe("Property Name Decorator", () => {
  describe("@RegisterDefaultAction decorator", () => {
    it("should register in default action the action 'Get All'", () => {
      const baseConstructor = {};
      const actionToRegister = "Get All";
      const options = {test: true} as ActionOptions;
      const callback = () => null;
      const meta = SolidifyMetadataUtil.ensureStoreSolidifyMetadata(baseConstructor.constructor as any);
      const registerDefaultAction = RegisterDefaultAction(callback, options);
      registerDefaultAction.call(null, baseConstructor, actionToRegister, null);
      expect(meta.defaultActions.length).toBe(1);
      expect(meta.defaultActions[0].fn).toBe(actionToRegister);
      expect(meta.defaultActions[0].callback).toBe(callback);
      expect(meta.defaultActions[0].options).toBe(options);
      baseConstructor.constructor[SOLIDIFY_META_KEY] = undefined;
    });
  });

  describe("@OverrideDefaultAction decorator", () => {
    it("should register in excluded default action the action 'Get All'", () => {
      const childConstructor = {};
      const actionToIgnore = "Get All";
      const meta = SolidifyMetadataUtil.ensureStoreSolidifyMetadata(childConstructor.constructor as any);
      const overrideDefaultAction = OverrideDefaultAction();
      overrideDefaultAction.call(null, childConstructor, actionToIgnore, null);
      expect(meta.excludedRegisteredDefaultActionFns.length).toBe(1);
      expect(meta.excludedRegisteredDefaultActionFns[0]).toBe(actionToIgnore);
      childConstructor.constructor[SOLIDIFY_META_KEY] = undefined;
    });
  });
});
