import {createSelector} from "@ngxs/store";
import {PlainObjectOf} from "@ngxs/store/internals";

// UNUSED:
// It's a copy of the code source of NGXS @Selector
// Just here to understand the logic of @Selector NGXS decorator (
/**
 * Decorator for memoizing a state selector.
 */
export function CopyOfNGXSSelector(selectors?: any[]): MethodDecorator {
  return <T>(
    target: any,
    key: string | symbol,
    descriptor: TypedPropertyDescriptor<T>,
  ): TypedPropertyDescriptor<T> | void => {
    const isNotMethod = !(descriptor && descriptor.value !== null);

    if (isNotMethod) {
      throw new Error(CONFIG_MESSAGES[VALIDATION_CODE.SELECTOR_DECORATOR]());
    }

    const originalFn = descriptor.value;
    let memoizedFn: any = null;
    const newDescriptor = {
      configurable: true,
      // tslint:disable-next-line:typedef
      get() {
        // Selector initialisation deferred to here so that it is at runtime, not decorator parse time
        memoizedFn =
          memoizedFn ||
          createSelector(
            selectors,
            originalFn as any,
            {
              containerClass: target,
              selectorName: key.toString(),
              // tslint:disable-next-line:typedef
              getSelectorOptions() {
                return {};
              },
            },
          );
        return memoizedFn;
      },
    };
    // Add hidden property to descriptor
    (<any> newDescriptor)["originalFn"] = originalFn;
    return newDescriptor;
  };
}

enum VALIDATION_CODE {
  SELECTOR_DECORATOR = "SELECTOR_DECORATOR"
}

const CONFIG_MESSAGES: PlainObjectOf<Function> = {
  [VALIDATION_CODE.SELECTOR_DECORATOR]: () => "Selectors only work on methods",
};
