import {PropertyName} from "./property-name.decorator";

describe("Store Decorator", () => {
  describe("@PropertyName decorator", () => {
    it("should generate name", () => {
      const prefix = "[";
      const suffix = "]";
      const propertyKey = "anAttribute";
      const action = {[propertyKey]: "should be erased"};
      const registerDefaultAction = PropertyName(prefix, suffix);
      registerDefaultAction.call(null, action, propertyKey);
      expect(action[propertyKey]).toBe(prefix + propertyKey + suffix);
    });
  });
});
