import {
  ActionOptions,
  ensureStoreMetadata,
} from "@ngxs/store";

// UNUSED:
// It's a copy of the code source of NGXS @Action
// Just here to understand the logic of @Action NGXS decorator (
export function CopyOfNGXSAction(actions: any | any[], options?: ActionOptions): MethodDecorator {
  return (target: any, name: string, descriptor: TypedPropertyDescriptor<any>) => {
    const meta = ensureStoreMetadata(target.constructor);

    if (!Array.isArray(actions)) {
      actions = [actions];
    }

    for (const action of actions) {
      const type = action.type;

      if (!action.type) {
        throw new Error(`Action ${action.name} is missing a static "type" property`);
      }

      if (!meta.actions[type]) {
        meta.actions[type] = [];
      }

      meta.actions[type].push({
        fn: name,
        options: options || {},
        type,
      });
    }
  };
}
