import {
  HttpBackend,
  HttpClient,
} from "@angular/common/http";
import {
  Injectable,
  Injector,
} from "@angular/core";
import {
  Observable,
  of,
} from "rxjs";
import {
  catchError,
  tap,
} from "rxjs/operators";
import {DefaultSolidifyEnvironment} from "../environments/environment.solidify-defaults";

@Injectable({
  providedIn: "root",
})
export class AppConfigService {

  public readonly CONSOLE_WARN_NO_ENVIRONMENT_RUNTIME_AVAILABLE: string = "No runtime config available, using the compiled environment config";
  public readonly CONSOLE_ERROR_LOADING_RUNTIME_CONFIG: string = "Error loading runtime config. An empty file named \"environment.runtime.json\" " +
    "must be available in the application assets/configurations/ folder";
  private readonly CONFIG_FILE_URL: string = "./assets/configurations/environment.runtime.json";

  constructor(private injector: Injector) {
  }

  mergeConfig(environment: DefaultSolidifyEnvironment): Observable<any> {
    if (environment.production === true || environment.forceRuntimeOverrideSetting === true) {
      const handler = this.injector.get(HttpBackend);
      const http = new HttpClient(handler);

      return http.get(this.CONFIG_FILE_URL)
        .pipe(
          tap(runtimeConfig => {
            // Merge runtime environment config into compiled environment.
            Object.assign(environment, runtimeConfig);
          }),
          catchError(err => {
            if (err.status === 404) {
              console.warn(err, this.CONSOLE_WARN_NO_ENVIRONMENT_RUNTIME_AVAILABLE);
            } else {
              console.error(err, this.CONSOLE_ERROR_LOADING_RUNTIME_CONFIG);
            }
            return of(null);
          }),
        );
    } else {
      return of(environment);
    }
  }

}
