// see: https://developer.mozilla.org/en-US/docs/Web/API/WindowBase64/Base64_encoding_and_decoding#The_.22Unicode_Problem.22
export function b64DecodeUnicode(str: string): string {
  const base64 = str.replace(/\-/g, "+").replace(/\_/g, "/");

  return decodeURIComponent(
    atob(base64)
      .split("")
      // tslint:disable-next-line:only-arrow-functions
      .map((c: string) => "%" + ("00" + c.charCodeAt(0).toString(16)).slice(-2))
      .join(""),
  );
}
