GIT repository for Solidify Frontend

# Solidify Frontend Lib

## Install

Run `npm install` to install the lib
Run `npm install -g typescript@3.4.5` to install typescript globally

## Build

Run `ng build` to build the solidify library

Then to build schematics on the lib: 

    cd projects/solidify-frontend
    npm run build
    

## Integration

### General
If you want to integrate the lib on you project you need to copy the folder called `solidify-frontend` on `dist` and past it in the `node_modules` of your project.

### For DLCM
You can use the command `npm run build-dlcm`
NB : The folder `DLCM-Portal` should be sibling of the current folder !

# Solidify Schematics

This repository is the solidify Schematic to complete the existing Angular CLI.
It allow to generate quickly boilerplate of components like view, container or dialog.

Reminder :
- Routable : Component routable. Can communicate with the store (dispatch actions and retrieve datas from store)
- Containers : Component non routable. Can communicate with the store (dispatch actions and retrieve datas from store)
- Dialog : Component embedded in a material modal. Can communicate with the store (dispatch actions and retrieve datas from store)
- Presentationals : Dumb component (just input / output, no connection with store)

## Testing generation outside a project

To test locally, install `@angular-devkit/schematics-cli` globally and use the `schematics` command line tool. That tool acts the same as the `generate` command of the Angular CLI, but also has a debug mode.
```bash
npm i -g @angular-devkit/schematics-cli
```

Check the documentation with
```bash
schematics --help
```

## Unit Testing

`npm run test-schematics` will run the unit tests, using Jasmine as a runner and test framework.

## Usage

When the lib solidify is integrated on a CLI project, you can run the following command depending of the kind of pattern you want to generate :

    ng g  solidify-frontend:routable my-routable
    ng g  solidify-frontend:routable
    ng g  solidify-frontend:container my-container
    ng g  solidify-frontend:container
    ng g  solidify-frontend:presentational my-presentational
    ng g  solidify-frontend:presentational
    ng g  solidify-frontend:dialog my-dialog
    ng g  solidify-frontend:dialog
    ng g  solidify-frontend:store-resource my-store-resource
    ng g  solidify-frontend:store-resource
    ng g  solidify-frontend:store-relation-2-tiers my-store-relation-2-tiers
    ng g  solidify-frontend:store-relation-2-tiers
    ng g  solidify-frontend:store-composition my-store-composition
    ng g  solidify-frontend:store-composition
