import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  BaseAction,
  BaseSubAction,
} from "solidify-frontend";

const state = LocalStateEnum.application_toc;

export namespace AppTocAction {
  export class GetAllDocumentation extends BaseAction {
    static readonly type: string = `[${state}] Get All Documentation`;
  }

  export class GetAllDocumentationSuccess extends BaseSubAction<GetAllDocumentation> {
    static readonly type: string = `[${state}] Get All Documentation Success`;

    constructor(public parentAction: GetAllDocumentation) {
      super(parentAction);
    }
  }

  export class GetAllDocumentationFail extends BaseSubAction<GetAllDocumentation> {
    static readonly type: string = `[${state}] Get All Documentation Fail`;
  }

  export class GetToolsGuide extends BaseAction {
    static readonly type: string = `[${state}] Get Tools Guide`;
  }

  export class GetToolsGuideSuccess extends BaseSubAction<GetToolsGuide> {
    static readonly type: string = `[${state}] Get Tools Guide Success`;

    constructor(public parentAction: GetToolsGuide, public toolsGuide: string) {
      super(parentAction);
    }
  }

  export class GetToolsGuideFail extends BaseSubAction<GetToolsGuide> {
    static readonly type: string = `[${state}] Get Tools Guide Fail`;
  }

  export class GetIntegrationGuide extends BaseAction {
    static readonly type: string = `[${state}] Get Integration Guide`;
  }

  export class GetIntegrationGuideSuccess extends BaseSubAction<GetIntegrationGuide> {
    static readonly type: string = `[${state}] Get Integration Guide Success`;

    constructor(public parentAction: GetIntegrationGuide, public integrationGuide: string) {
      super(parentAction);
    }
  }

  export class GetIntegrationGuideFail extends BaseSubAction<GetIntegrationGuide> {
    static readonly type: string = `[${state}] Get Integration Guide Fail`;
  }

  export class GetApis extends BaseAction {
    static readonly type: string = `[${state}] Get Apis`;
  }

  export class GetApisSuccess extends BaseSubAction<GetApis> {
    static readonly type: string = `[${state}] Get Apis Success`;

    constructor(public parentAction: GetApis, public apis: string) {
      super(parentAction);
    }
  }

  export class GetApisFail extends BaseSubAction<GetApis> {
    static readonly type: string = `[${state}] Get Apis Fail`;
  }

  export class GetUserDocumentation extends BaseAction {
    static readonly type: string = `[${state}] Get User Documentation`;
  }

  export class GetUserDocumentationSuccess extends BaseSubAction<GetUserDocumentation> {
    static readonly type: string = `[${state}] Get User Documentation Success`;

    constructor(public parentAction: GetUserDocumentation, public userDocumentation: string) {
      super(parentAction);
    }
  }

  export class GetUserDocumentationFail extends BaseSubAction<GetUserDocumentation> {
    static readonly type: string = `[${state}] Get User Documentation Fail`;
  }
}

export const appTocActionNameSpace = AppTocAction;
