import {OrganizationalUnitPersonRole} from "@admin/models/organizational-unit-person-role.model";
import {PersonRole} from "@admin/models/person-role.model";
import {Injectable} from "@angular/core";
import {ApiResourceNameEnum} from "@app/shared/enums/api-resource-name.enum";
import {AdminResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {
  AppOrgUnitPersonRoleAction,
  appOrgUnitPersonRoleActionNameSpace,
} from "@app/stores/organizational-unit-person-role/app-organizational-unit-person-role.action";
import {environment} from "@environments/environment";

import {
  Action,
  Actions,
  State,
  StateContext,
  Store,
} from "@ngxs/store";
import {
  ApiService,
  defaultRelation3TiersStateInitValue,
  NotificationService,
  OverrideDefaultAction,
  QueryParameters,
  Relation3TiersForm,
  Relation3TiersState,
  Relation3TiersStateModel,
} from "solidify-frontend";

export interface AppOrganizationalUnitPersonRoleStateModel extends Relation3TiersStateModel<PersonRole> {
}

@Injectable()
@State<AppOrganizationalUnitPersonRoleStateModel>({
  name: LocalStateEnum.application_organizationalUnit_personRole,
  defaults: {
    ...defaultRelation3TiersStateInitValue(),
    queryParameters: new QueryParameters(environment.maximalPageSizeToRetrievePaginationInfo),
  },
})
// OrganizationalUnitPersonController
export class AppOrganizationalUnitPersonRoleState extends Relation3TiersState<AppOrganizationalUnitPersonRoleStateModel, PersonRole, OrganizationalUnitPersonRole> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: appOrgUnitPersonRoleActionNameSpace,
      resourceName: ApiResourceNameEnum.PERSON,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.organizationalUnits;
  }

  protected convertResourceInForm(resource: PersonRole): Relation3TiersForm {
    return {id: resource.resId, listId: resource.roles.map(r => r.resId)};
  }

  @OverrideDefaultAction()
  @Action(AppOrgUnitPersonRoleAction.GetByIdSuccess)
  getByIdSuccess(ctx: StateContext<AppOrganizationalUnitPersonRoleStateModel>, action: AppOrgUnitPersonRoleAction.GetByIdSuccess): void {
    action.current.orgUnitId = action.parentAction.parentId;
    ctx.patchState({
      current: action.current,
      isLoadingCounter: ctx.getState().isLoadingCounter - 1,
    });
  }
}
