import {Injectable} from "@angular/core";
import {AdminResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {appNotificationInboxActionNameSpace} from "@app/stores/notification-inbox/app-notification-inbox.action";
import {NotificationDlcm} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  QueryParameters,
  ResourceState,
  ResourceStateModel,
} from "solidify-frontend";
import {environment} from "../../../environments/environment";

export interface AppNotificationInboxStateModel extends ResourceStateModel<NotificationDlcm> {
}

@Injectable()
@State<AppNotificationInboxStateModel>({
  name: LocalStateEnum.application_notificationInbox,
  defaults: {
    ...defaultResourceStateInitValue(),
    queryParameters: new QueryParameters(environment.defaultEnumValuePageSizeOption),
  },
})
export class AppNotificationInboxState extends ResourceState<AppNotificationInboxStateModel, NotificationDlcm> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: appNotificationInboxActionNameSpace,
      keepCurrentStateAfterUpdate: true,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.notificationsInbox;
  }
}
