import {Injectable} from "@angular/core";
import {appCartDipDataFileActionNameSpace} from "@app/stores/cart/dip/data-file/app-cart-dip-data-file.action";
import {
  Action,
  Actions,
  State,
  StateContext,
  Store,
} from "@ngxs/store";
import {DipDataFile} from "@preservation-planning/dip/models/dip-data-file.model";
import {PreservationPlanningDipDataFileAction} from "@preservation-planning/dip/stores/data-file/preservation-planning-dip-data-file.action";
import {ApiActionEnum} from "@shared/enums/api-action.enum";
import {ApiResourceNameEnum} from "@shared/enums/api-resource-name.enum";
import {AccessResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {DownloadService} from "@shared/services/download.service";
import {
  ApiService,
  CompositionState,
  CompositionStateModel,
  defaultCompositionStateInitValue,
  NotificationService,
} from "solidify-frontend";

export const defaultAppCartDipDataFileValue: () => AppCartDipDataFileStateModel = () =>
  ({
    ...defaultCompositionStateInitValue(),
  });

export interface AppCartDipDataFileStateModel extends CompositionStateModel<DipDataFile> {
}

@Injectable()
@State<AppCartDipDataFileStateModel>({
  name: LocalStateEnum.application_cart_dip_dataFile,
  defaults: {
    ...defaultAppCartDipDataFileValue(),
  },
  children: [],
})
export class AppCartDipDataFileState extends CompositionState<AppCartDipDataFileStateModel, DipDataFile> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions,
              private downloadService: DownloadService) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: appCartDipDataFileActionNameSpace,
      resourceName: ApiResourceNameEnum.DATAFILE,
    });
  }

  protected get _urlResource(): string {
    return AccessResourceApiEnum.dip;
  }

  @Action(PreservationPlanningDipDataFileAction.Download)
  download(ctx: StateContext<AppCartDipDataFileStateModel>, action: PreservationPlanningDipDataFileAction.Download): void {
    const url = `${this._urlResource}/${action.parentId}/${this._resourceName}/${action.dataFile.resId}/${ApiActionEnum.DL}`;
    this.downloadService.download(false, url, action.dataFile.fileName, action.dataFile.fileSize);
  }
}
